﻿uses
  Classes, Common, DataEntry, DataStorage, DateUtils, SysUtils, Variants;

// OnStart filter --------------------------------------------------------------
procedure OnStartFilter(aDataStore: TDataStore; Var DoContinue: boolean; Var OutObj: TObject);
const
  SPACE = ' ';

var
  Param_StringList: TStringList;
  FilterLogging_StringList: TStringList;
  i: integer;
  FilterFileName_log_str: string;
  FilterPath_str: string;
  LogFileFullPath_str: string;
  FilterFileName_pas_str: string;
  FilterFileName_txt_str: string;

begin
  DoContinue := True;
  FilterPath_str := CmdLine.Path;
  FilterFileName_pas_str := ExtractFileName(FilterPath_str);
  Param_StringList := TStringList.Create;
  FilterLogging_StringList := TStringList.Create;
  try
    if CmdLine.ParamCount > 0 then
    begin
      for i := 0 to CmdLine.ParamCount - 1 do
      begin
        Param_StringList.Add(CmdLine.params[i]);
      end;
    end
    else
      FilterLogging_StringList.Add('No parameters received.');

    // Save Manual Log File
    FilterFileName_log_str := StringReplace('aaaaaaaaaaaaaaaaaaaaaaa', '.pas', '.log', [rfReplaceAll, rfIgnoreCase]);
    LogFileFullPath_str := GetCurrentCaseDir + 'Logs' + '\' + 'FILTER - ' + SPACE + UpperCase(FilterFileName_log_str);
    FilterLogging_StringList.Add('Log File: ' + LogFileFullPath_str);
    FilterLogging_StringList.SaveToFile(LogFileFullPath_str);

  finally
    FilterLogging_StringList.free;
  end;
  OutObj := Param_StringList;
end;

// Run the filter --------------------------------------------------------------
function FilterEntry(anEntry: TEntry; InObj: TObject): integer;
var
  aStringList: TStringList;
  i: integer;
begin
  Result := -1; // Exclude
  if (InObj = nil) or not(InObj is TStringList) then
    Exit;
  aStringList := TStringList(InObj);
  if aStringList.Count > 0 then
  begin
    if assigned(anEntry) then
    begin
      for i := 0 to aStringList.Count - 1 do
      begin
        if POS(aStringList[i], anEntry.FullPathName) > 0 then
          Result := 1; // Exclude
      end;
    end;
  end;
end;

procedure OnendFilter(Var OutObj: TObject);
begin
  if (OutObj <> nil) and (OutObj is TStringList) then
    OutObj.free;
end;

begin

end.
